/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.thonkutil.config.option;

import com.jab125.thonkutil.ThonkUtilBaseClass;
import com.jab125.thonkutil.config.option.ConfigOptionStorage;
import com.jab125.thonkutil.config.option.OptionConvertable;
import com.jab125.thonkutil.util.translation.TranslationUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_4064;
import net.minecraft.class_5244;

public class BooleanConfigOption
implements OptionConvertable,
ThonkUtilBaseClass {
    private final String key;
    private final String translationKey;
    private final boolean defaultValue;
    private final class_2561 enabledText;
    private final class_2561 disabledText;

    public BooleanConfigOption(String key, String modid, boolean defaultValue, String enabledKey, String disabledKey) {
        ConfigOptionStorage.setBoolean(key, defaultValue);
        this.key = key;
        this.translationKey = TranslationUtil.translationKeyOf("option", modid, key);
        this.defaultValue = defaultValue;
        this.enabledText = new class_2588(this.translationKey + "." + enabledKey);
        this.disabledText = new class_2588(this.translationKey + "." + disabledKey);
    }

    public BooleanConfigOption(String key, String modid, boolean defaultValue) {
        this(key, modid, defaultValue, "true", "false");
    }

    public String getKey() {
        return this.key;
    }

    public boolean getValue() {
        return ConfigOptionStorage.getBoolean(this.key);
    }

    public void setValue(boolean value) {
        ConfigOptionStorage.setBoolean(this.key, value);
    }

    public void toggleValue() {
        ConfigOptionStorage.toggleBoolean(this.key);
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public class_2561 getButtonText() {
        return class_5244.method_32700((class_2561)new class_2588(this.translationKey), (class_2561)(this.getValue() ? this.enabledText : this.disabledText));
    }

    @Environment(value=EnvType.CLIENT)
    public class_4064<Boolean> asOption() {
        if (this.enabledText != null && this.disabledText != null) {
            return class_4064.method_32525((String)this.translationKey, (class_2561)this.enabledText, (class_2561)this.disabledText, ignored -> ConfigOptionStorage.getBoolean(this.key), (ignored, option, value) -> ConfigOptionStorage.setBoolean(this.key, value));
        }
        return class_4064.method_32522((String)this.translationKey, ignored -> ConfigOptionStorage.getBoolean(this.key), (ignored, option, value) -> ConfigOptionStorage.setBoolean(this.key, value));
    }
}

